/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import ibm.nways.ras.ErrorLogServerHandle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ErrorLogServerImpl
extends UnicastRemoteObject
implements ErrorLogServerHandle {
    private PrintWriter traceFile;
    private PrintWriter logFile;
    private DateFormat df;
    private static final String traceFileSpec = "log/Nways_trace.txt";
    private static final String logFileSpec = "log/Nways_log.txt";
    int traceFileSize;
    int logFileSize;
    int maxTraceFileSize = 1000000;
    int maxLogFileSize = 1000000;

    public ErrorLogServerImpl() throws RemoteException {
        File file = new File("log");
        if (!file.exists()) {
            file.mkdir();
        } else if (!file.isDirectory()) {
            file.delete();
            file.mkdir();
        }
        this.traceFile = this.openFile(traceFileSpec);
        this.logFile = this.openFile(logFileSpec);
        this.df = DateFormat.getDateTimeInstance(3, 1);
        this.df.setTimeZone(TimeZone.getDefault());
    }

    private PrintWriter openFile(String string) {
        File file = new File(string);
        PrintWriter printWriter = null;
        if (file.exists()) {
            File file2 = new File(String.valueOf(string) + ".bak");
            file.renameTo(file2);
        }
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            printWriter = null;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            printWriter = null;
        }
        return printWriter;
    }

    public void trace(String string) throws RemoteException {
        if (this.traceFileSize > this.maxTraceFileSize) {
            this.traceFile.close();
            this.traceFile = this.openFile(traceFileSpec);
            this.traceFileSize = 0;
        }
        if (this.traceFile != null) {
            Date date = new Date();
            this.traceFile.print(this.df.format(date));
            this.traceFile.print(":  ");
            this.traceFile.println(string);
            this.traceFile.flush();
            this.traceFileSize += 15;
            this.traceFileSize += string.length();
        }
    }

    public void log(String string) throws RemoteException {
        if (this.logFileSize > this.maxLogFileSize) {
            this.logFile.close();
            this.logFile = this.openFile(logFileSpec);
            this.logFileSize = 0;
        }
        if (this.logFile != null) {
            Date date = new Date();
            this.logFile.print(this.df.format(date));
            this.logFile.print(":  ");
            this.logFile.println(string);
            this.logFile.flush();
            this.logFileSize += 15;
            this.logFileSize += string.length();
        }
    }

    public void close() throws RemoteException {
        this.traceFile.close();
        this.logFile.close();
        this.traceFile = null;
        this.logFile = null;
    }

    public void flush() throws RemoteException {
        this.traceFile.flush();
        this.logFile.flush();
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            System.err.println("ErrorLogServerImpl.main:  creating ErrorLog");
            ErrorLogServerImpl errorLogServerImpl = new ErrorLogServerImpl();
            String string = "ErrorLog";
            System.err.println("binding to name: " + string);
            Naming.rebind(string, errorLogServerImpl);
            return;
        }
        catch (Exception exception) {
            System.err.println("Exception creating server: " + exception + "\n");
            exception.printStackTrace(System.err);
            return;
        }
    }
}

